### **Windows 右键菜单一键翻译 PDF**

本教程将指导你在 Windows 系统中配置一个强大、高效的右键菜单翻译功能。配置完成后，你可以在电脑的任何位置，通过简单的右键点击，快速翻译任意 PDF 文件，并能实时查看翻译进度。

### ✨ **功能亮点**

- **全局通用**：在电脑的任意位置，无论是桌面还是文件夹，右键点击 PDF 文件即可使用。
- **实时交互**：翻译过程会显示在一个独立的命令行窗口中，你可以**实时查看进度条**，也可以随时按 `Ctrl+C` **手动中断**任务。
- **即时响应**：只有在你点击翻译时，才会启动进程；任务完成后，进程自动退出，不占用任何待机资源。
- **高度可配**：你可以轻松地在脚本中添加自定义参数，例如切换翻译服务、使用术语表或生成单语/双语文件。
- **清晰反馈**：任务开始、成功、失败或取消，都会有明确的系统通知和命令行提示。

---

#### zeroth_step **第零步：准备工作**

在开始之前，我们需要定位到你存放 `zotero-pdf2zh` 项目的文件夹，并将其作为我们配置右键菜单的“根目录”。

1.  **定位项目文件夹**
    首先，请找到你的 `zotero-pdf2zh` 项目所在的文件夹。

2.  **获取核心脚本**
    请确保你已将以下四个脚本文件放入刚刚创建的文件夹中：

    - `translate_pdf_context.cmd` (右键菜单实际调用的批处理脚本)
    - `translate_pdf_client.py` (负责调用翻译引擎的 Python 脚本)
    - `register_context_menu.ps1` (用于一键注册右键菜单的 PowerShell 脚本)
    - `unregister_context_menu.ps1` (用于一键卸载右键菜单的 PowerShell 脚本)

3.  **创建 Python 虚拟环境**
    为确保工具的稳定运行，我们强烈建议为此项目创建一个独立的 Python 虚拟环境，并命名为 `.venv`。

---

#### 🚀 **第一步：配置运行环境**

接下来，我们将激活虚拟环境并安装必要的依赖库。

1.  **打开终端并激活环境**
    打开 PowerShell 终端，使用 `cd` 命令进入你的项目文件夹，然后运行命令激活虚拟环境。

    ```powershell
    # 示例路径，请务必替换为你自己的真实路径
    cd D:\Tools\PdfTranslate

    # 激活 .venv 环境 (注意 Windows 下的正确路径)
    .\.venv\Scripts\activate
    ```

    > **小贴士**：激活成功后，你会在命令行提示符前看到 `(.venv)` 标志。

2.  **安装依赖库**
    在**已激活虚拟环境**的终端中，运行以下命令来安装 Windows 通知库：

    ```powershell
    pip install win10toast-click
    ```

---

#### ⚙️ **第二步：自定义翻译配置 (可选)**

脚本默认配置已可直接使用。如果你希望调整翻译行为（如更换引擎、修改输出格式），可以按以下步骤操作。

1.  **编辑批处理脚本**
    用文本编辑器（如 VS Code 或记事本）打开 `translate_pdf_context.cmd` 文件。

2.  **修改参数**
    找到文件头部的 `[配置区]`。你只需修改 `set "PDF2ZH_OPTIONS="` 这一行。

    ```batch
    @echo off
    REM === [配置区] (在这里修改你的常用翻译参数) ============================

    REM --- 1. Python 虚拟环境的名称 (通常无需修改) ---
    set "VENV_NAME=.venv"

    REM --- 2. 在这里添加你想要的 pdf2zh 额外参数 ---
    set "PDF2ZH_OPTIONS="

    REM --- 示例 1: 使用 DeepL 翻译，并生成仅译文文件 ---
    REM set "PDF2ZH_OPTIONS=--translator deepl --no-dual"

    REM --- 示例 2: 使用指定的术语表 ---
    REM set "PDF2ZH_OPTIONS=--glossary-file "./my_glossary.txt""

    REM ========================================================================
    ```

    例如，若想默认使用 **DeepSeek** 翻译引擎，并且**不要**生成双语对照文件，可以修改为：

    ```batch
    set "PDF2ZH_OPTIONS=--translator deepseek --no-dual"
    ```

---

#### 🛠️ **第三步：注册右键菜单**

这是最关键的一步，它会将翻译功能添加到 Windows 的右键菜单中。

1.  **以管理员身份运行 PowerShell**
    在 Windows 开始菜单搜索 `PowerShell`，右键点击“Windows PowerShell”，选择“**以管理员身份运行**”。

    > **为何需要管理员权限？** 因为向系统注册表添加右键菜单项属于系统级操作，需要管理员权限。

2.  **设置执行策略（重要）**
    为了允许执行本地脚本，请在**管理员 PowerShell** 窗口中运行以下命令。这仅对当前窗口生效，不会影响系统全局安全设置。

    ```powershell
    Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope Process
    ```

3.  **执行注册脚本**
    在同一个**管理员 PowerShell** 窗口中，先进入你的项目文件夹，然后执行注册脚本：

    ```powershell
    # 1. 切换到你的项目文件夹 (请使用你的真实路径)
    cd D:\Tools\PdfTranslate

    # 2. 运行注册脚本
    .\register_context_menu.ps1
    ```

    执行成功后，脚本会将翻译命令写入 Windows 注册表。

4.  **验证效果**
    现在，在任意位置右键点击一个 PDF 文件，你应该能看到一个新的选项：“**一键翻译此PDF (pdf2zh)**”。

    > **Windows 11 用户注意**: 该选项可能被折叠在 “**显示更多选项**” 的二级菜单中。点击后，会弹出一个命令行窗口开始执行翻译。

---

#### 🗑️ **第四步：如何卸载右键菜单**

如果你不再需要此功能，可以轻松地将其从系统中完全移除。

1.  **以管理员身份运行 PowerShell**。

2.  **进入项目目录并执行卸载脚本**：

    ```powershell
    # 1. 切换到你的项目文件夹 (请使用你的真实路径)
    cd D:\Tools\PdfTranslate

    # 2. 执行卸载脚本
    .\unregister_context_menu.ps1
    ```

    此命令会安全地清理掉之前添加到注册表的所有信息，右键菜单项会立即消失。之后，你可以放心地删除整个项目文件夹。
